/**
 *  Copyright (c) 2012 BMW
 *
 *  \author Christian Mueller, christian.ei.mueller@bmw.de BMW 2011,2012
 *
 *  \copyright
 *  Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction,
 *  including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so,
 *  subject to the following conditions:
 *  The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
 *  THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *  For further information see http://www.genivi.org/.
 */

#ifndef CONTROLSENDER_H_
#define CONTROLSENDER_H_

class amcontrol_clienthandler_fc_audiomanager;
class amcontrol_clienthandler_fc_audioroutemanager;

#include "control/IAmControlSend.h"
#include "IAmControlReceiverShadow.h"

#include <list>
#include <map>

class CAmControlSenderBase: public IAmControlSend
{
public:
    CAmControlSenderBase();
    virtual ~CAmControlSenderBase();
    am_Error_e startupController(IAmControlReceive* controlreceiveinterface);
    void setControllerReady();
    void setControllerRundown(const int16_t signal);
    void cbAckCCAMessageReceived();
    am_Error_e hookUserConnectionRequest(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am_mainConnectionID_t& mainConnectionID);
    am_Error_e hookUserDisconnectionRequest(const am_mainConnectionID_t connectionID);
    am_Error_e hookUserSetMainSinkSoundProperty(const am_sinkID_t sinkID, const am_MainSoundProperty_s& soundProperty);
    am_Error_e hookUserSetMainSourceSoundProperty(const am_sourceID_t sourceID, const am_MainSoundProperty_s& soundProperty);
    am_Error_e hookUserSetSystemProperty(const am_SystemProperty_s& property);
    am_Error_e hookUserVolumeChange(const am_sinkID_t SinkID, const am_mainVolume_t newVolume);
    am_Error_e hookUserVolumeStep(const am_sinkID_t SinkID, const int16_t increment);
    am_Error_e hookUserSetSinkMuteState(const am_sinkID_t sinkID, const am_MuteState_e muteState);
    am_Error_e hookSystemRegisterDomain(const am_Domain_s& domainData, am_domainID_t& domainID);
    am_Error_e hookSystemDeregisterDomain(const am_domainID_t domainID);
    void hookSystemDomainRegistrationComplete(const am_domainID_t domainID);
    am_Error_e hookSystemRegisterSink(const am_Sink_s& sinkData, am_sinkID_t& sinkID);
    am_Error_e hookSystemDeregisterSink(const am_sinkID_t sinkID);
    am_Error_e hookSystemRegisterSource(const am_Source_s& sourceData, am_sourceID_t& sourceID);
    am_Error_e hookSystemDeregisterSource(const am_sourceID_t sourceID);
    am_Error_e hookSystemRegisterGateway(const am_Gateway_s& gatewayData, am_gatewayID_t& gatewayID);
    am_Error_e hookSystemDeregisterGateway(const am_gatewayID_t gatewayID);
    am_Error_e hookSystemRegisterCrossfader(const am_Crossfader_s& crossfaderData, am_crossfaderID_t& crossfaderID);
    am_Error_e hookSystemDeregisterCrossfader(const am_crossfaderID_t crossfaderID);
    void hookSystemSinkVolumeTick(const am_Handle_s handle, const am_sinkID_t sinkID, const am_volume_t volume);
    void hookSystemSourceVolumeTick(const am_Handle_s handle, const am_sourceID_t sourceID, const am_volume_t volume);
    void hookSystemInterruptStateChange(const am_sourceID_t sourceID, const am_InterruptState_e interruptState);
    void hookSystemSinkAvailablityStateChange(const am_sinkID_t sinkID, const am_Availability_s& availability);
    void hookSystemSourceAvailablityStateChange(const am_sourceID_t sourceID, const am_Availability_s& availability);
    void hookSystemDomainStateChange(const am_domainID_t domainID, const am_DomainState_e state);
    void hookSystemReceiveEarlyData(const std::vector<am_EarlyData_s>& data);
    void hookSystemSpeedChange(const am_speed_t speed);
    void hookSystemTimingInformationChanged(const am_mainConnectionID_t mainConnectionID, const am_timeSync_t time);
    void cbAckConnect(const am_Handle_s handle, const am_Error_e errorID);
    void cbAckDisconnect(const am_Handle_s handle, const am_Error_e errorID);
    void cbAckCrossFade(const am_Handle_s handle, const am_HotSink_e hostsink, const am_Error_e error);
    void cbAckSetSinkVolumeChange(const am_Handle_s handle, const am_volume_t volume, const am_Error_e error);
    void cbAckSetSourceVolumeChange(const am_Handle_s handle, const am_volume_t voulme, const am_Error_e error);
    void cbAckSetSourceState(const am_Handle_s handle, const am_Error_e error);
    void cbAckSetSourceSoundProperties(const am_Handle_s handle, const am_Error_e error);
    void cbAckSetSourceSoundProperty(const am_Handle_s handle, const am_Error_e error);
    void cbAckSetSinkSoundProperties(const am_Handle_s handle, const am_Error_e error);
    void cbAckSetSinkSoundProperty(const am_Handle_s handle, const am_Error_e error);
    am_Error_e getConnectionFormatChoice(const am_sourceID_t sourceID, const am_sinkID_t sinkID, const am_Route_s listRoute, const std::vector<am_ConnectionFormat_e> listPossibleConnectionFormats, std::vector<am_ConnectionFormat_e>& listPrioConnectionFormats);
    void getInterfaceVersion(std::string& version) const;
    void confirmCommandReady(const am_Error_e error);
    void confirmRoutingReady(const am_Error_e error);
    void confirmCommandRundown(const am_Error_e error);
    void confirmRoutingRundown(const am_Error_e error);

   /*********************************audiomanager 2.0 version**********************************************/
   am_Error_e hookSystemUpdateSink(const am_sinkID_t sinkID, const am_sinkClass_t sinkClassID, const std::vector<am_SoundProperty_s>& listSoundProperties, const std::vector<am_ConnectionFormat_e>& listConnectionFormats, const std::vector<am_MainSoundProperty_s>& listMainSoundProperties) ;
    am_Error_e hookSystemUpdateSource(const am_sourceID_t sourceID, const am_sourceClass_t sourceClassID, const std::vector<am_SoundProperty_s>& listSoundProperties, const std::vector<am_ConnectionFormat_e>& listConnectionFormats, const std::vector<am_MainSoundProperty_s>& listMainSoundProperties) ;
    am_Error_e hookSystemUpdateGateway(const am_gatewayID_t gatewayID, const std::vector<am_ConnectionFormat_e>& listSourceConnectionFormats, const std::vector<am_ConnectionFormat_e>& listSinkConnectionFormats, const std::vector<bool>& convertionMatrix) ;
    void cbAckSetVolumes(const am_Handle_s handle, const std::vector<am_Volumes_s>& listVolumes, const am_Error_e error) ;
    void cbAckSetSinkNotificationConfiguration(const am_Handle_s handle, const am_Error_e error) ;
    void cbAckSetSourceNotificationConfiguration(const am_Handle_s handle, const am_Error_e error) ;
    void hookSinkNotificationDataChanged(const am_sinkID_t sinkID, const am_NotificationPayload_s& payload) ;
    void hookSourceNotificationDataChanged(const am_sourceID_t sourceID, const am_NotificationPayload_s& payload) ;
    am_Error_e hookUserSetMainSinkNotificationConfiguration(const am_sinkID_t sinkID, const am_NotificationConfiguration_s& notificationConfiguration) ;
    am_Error_e hookUserSetMainSourceNotificationConfiguration(const am_sourceID_t sourceID, const am_NotificationConfiguration_s& notificationConfiguration) ;
    void hookSystemNodeStateChanged(const NsmNodeState_e NodeStateId) ;
    void hookSystemNodeApplicationModeChanged(const NsmApplicationMode_e ApplicationModeId) ;
    void hookSystemSessionStateChanged(const std::string& sessionName, const NsmSeat_e seatID, const NsmSessionState_e sessionStateID) ;
    NsmErrorStatus_e hookSystemLifecycleRequest(const uint32_t Request, const uint32_t RequestId) ;
   /*********************************audiomanager 2.0 version**********************************************/

    void InitStackManager();

private:
    /**********************************Data Members*****************************************************/

    am_domainID_t g_domainId;
    std::map<uint16_t, am::am_Source_s> m_aSourceMap;
    std::map<uint16_t, am::am_Sink_s> m_aSinkMap;

    CAmSocketHandler* m_pSocketHandler;
    IAmControlReceive * mControlReceiveInterface;
    IAmControlReceiverShadow * mControlReceiveShadowInterface;

   amcontrol_clienthandler_fc_audioroutemanager* mClientHandlerAudioRouteMgr;
    amcontrol_clienthandler_fc_audiomanager* mClientHandlerFCAudioMgr;

    struct rHandleStatus
    {
        bool status;
        am_Handle_s handle;
    };

    struct rMainVolumeSet
    {
        am_sinkID_t sinkID;
        am_Handle_s handle;
        am_mainVolume_t mainVolume;
        am_MuteState_e muteState;
    };

    struct rMainSourceSoundPropertySet
    {
        am_sourceID_t sourceID;
        am_Handle_s handle;
        am_MainSoundProperty_s mainSoundProperty;
    };

    struct rMainSinkSoundPropertySet
    {
      am_sinkID_t sinkID;
        am_Handle_s handle;
        am_MainSoundProperty_s mainSoundProperty;
    };

    class findHandle
    {
        rHandleStatus mHandle;
    public:
        explicit findHandle(rHandleStatus handle) :
                mHandle(handle)
        {
        }
        bool operator()(const rHandleStatus& handle) const
        {
            return (handle.handle.handle == mHandle.handle.handle);
        }
    };

    struct rCheckHandle
    {

        rHandleStatus mrHandleStatus;
        explicit rCheckHandle(const rHandleStatus& value) :
                mrHandleStatus(value)
        {
        }

        bool operator()(const rHandleStatus &value)
        {
            return !value.status;
        }
    };

    struct rCheckMainConnectionID
    {
        am_MainConnection_s mMainConnection;
        explicit rCheckMainConnectionID(const am_MainConnection_s& mainConnection) :
                mMainConnection(mainConnection)
        {
        }
        bool operator()(const am_MainConnection_s& mainConnection)
        {
            if (mMainConnection.mainConnectionID == mainConnection.mainConnectionID)
                return true;
            return false;
        }
    };
    enum cs_stateflow_e
    {
        SF_NONE,
        SF_CONNECT,
        SF_NAVI,
        SF_TA
    };

    enum cs_connectSf_e
    {
        SFC_RAMP_DOWN,
        SFC_SOURCE_STATE_OFF,
        SFC_DISCONNECT,
        SFC_CONNECT,
        SFC_SOURCE_STATE_ON,
        SFC_RAMP_UP,
        SFC_FINISHED
    };

   struct cs_connectData_s
    {
        am_mainConnectionID_t currentMainConnection;
        am_mainConnectionID_t newMainConnection;
        am_sourceID_t oldSourceID;
        am_sinkID_t sinkID;
        am_sourceID_t sourceID;
    };

    std::vector<rMainVolumeSet> mListOpenVolumeChanges;
    std::vector<rMainVolumeSet> mListOpenMuteDemuteChanges;
    std::vector<rMainSourceSoundPropertySet> mListMainSourceSoundPropertyChanges;
    std::vector<rMainSinkSoundPropertySet> mListMainSinkSoundPropertyChanges;
    std::vector<am_SystemProperty_s> mListMainSystemSoundPropertyChanges;

   cs_connectSf_e mConnectSf;
    cs_connectData_s mConnectData;
    cs_stateflow_e mStateflow;

    /*******************************Methods********************************************************/

    void callStateFlowHandler();
    void callConnectHandler();

   void connect(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t mainConnectionID) const;
   void disconnect(am_mainConnectionID_t connectionID) const;

   am_Error_e enRegisterDomain();
   am_Error_e enRegisterSources();
   am_Error_e enRegisterSinks();
   am_Error_e DeRegistersAll();

   //to change sink sound properties
    void vChangeSinkSoundProperty_Bass(rMainSinkSoundPropertySet & soundProperty,uint16_t);
   void vChangeSinkSoundProperty_Treble(rMainSinkSoundPropertySet & soundProperty,uint16_t);
   void vChangeSinkSoundProperty_MidRange(rMainSinkSoundPropertySet & soundProperty,uint16_t);
   void vChangeSinkSoundProperty_Loudness(rMainSinkSoundPropertySet & soundProperty,uint16_t);
   void vChangeSinkSoundProperty_Balance(rMainSinkSoundPropertySet & soundProperty,uint16_t);
   void vChangeSinkSoundProperty_Fader(rMainSinkSoundPropertySet & soundProperty,uint16_t);

   void processIncCcaResponse();

   void vResponse_SourceChange(amt_tclServiceData* poMessage);
   void vResponse_AudioRoute(amt_tclServiceData* poMessage);
   void vResponse_SourceAvailability(amt_tclServiceData* poMessage);

   void vResponse_Volume(amt_tclServiceData* poMessage);
   void vResponse_Mute(amt_tclServiceData* poMessage);

   //to process response for sink sound properties
      void vResponse_SinkSndProp_Bass(amt_tclServiceData* poMessage);
      void vResponse_SinkSndProp_Treble(amt_tclServiceData* poMessage);
      void vResponse_SinkSndProp_MidRange(amt_tclServiceData* poMessage);
      void vResponse_SinkSndProp_Loudness(amt_tclServiceData* poMessage);
      void vResponse_SinkSndProp_Balance(amt_tclServiceData* poMessage);
      void vResponse_SinkSndProp_Fader(amt_tclServiceData* poMessage);
      void vResponse_SinkSndProp_DynCompression(amt_tclServiceData* poMessage);
      void vResponse_SinkSndProp_EquPreset(amt_tclServiceData* poMessage);
      void vResponse_SinkSndProp_Gala(amt_tclServiceData* poMessage);
      void vResponse_SinkSndProp_Optimization(amt_tclServiceData* poMessage);

      //to process response for source sound properties
      void vResponse_SrcSndProp_MicPhoneConn(amt_tclServiceData* poMessage);
      void vResponse_SrcSndProp_AuxInLevel(amt_tclServiceData* poMessage);

      //to process response for system sound properties
      void vResponse_SysSndProp_BeepStatus(amt_tclServiceData* poMessage);
      void vResponse_SysSndProp_FaderActivation(amt_tclServiceData* poMessage);
      void vResponse_SysSndProp_VolumeMode(amt_tclServiceData* poMessage);
};

#endif /* CONTROLSENDER_H_ */
